using System;
using System.IO;

class LiChao
{
    class Line
    {
        public long m, b;
        public Line(long m, long b) { this.m = m; this.b = b; }
        public long Get(long x) => m * x + b;
    }

    class Node
    {
        public Line line;
        public Node left, right;
        public Node(Line l) { line = l; }
    }

    Node root;
    long L, R;

    public LiChao(long l, long r)
    {
        L = l; R = r;
        root = null;
    }

    void Add(Line nw, ref Node node, long l, long r)
    {
        if (node == null)
        {
            node = new Node(nw);
            return;
        }

        long mid = (l + r) >> 1;
        bool left = nw.Get(l) > node.line.Get(l);
        bool m = nw.Get(mid) > node.line.Get(mid);

        if (m)
        {
            var tmp = node.line;
            node.line = nw;
            nw = tmp;
        }

        if (r - l == 1) return;

        if (left != m)
            Add(nw, ref node.left, l, mid);
        else
            Add(nw, ref node.right, mid, r);
    }

    public void AddLine(long m, long b)
    {
        Add(new Line(m, b), ref root, L, R);
    }

    long Query(long x, Node node, long l, long r)
    {
        if (node == null) return long.MinValue;
        long res = node.line.Get(x);
        if (r - l == 1) return res;
        long mid = (l + r) >> 1;
        if (x < mid && node.left != null)
            return Math.Max(res, Query(x, node.left, l, mid));
        if (x >= mid && node.right != null)
            return Math.Max(res, Query(x, node.right, mid, r));
        return res;
    }

    public long Query(long x)
    {
        return Query(x, root, L, R);
    }
}

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        long[] h = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);

        long minX = 0, maxX = 1_000_000_000;

        LiChao tree = new LiChao(minX, maxX + 1);

        for (int i = 0; i < n; i++)
            tree.AddLine(0, h[i]);

        for (int i = 0; i + 1 < n; i++)
        {
            tree.AddLine(-1, x[i] + h[i]);
            tree.AddLine(1, h[i + 1] - x[i + 1]);
        }

        for (int i = 0; i < n; i++)
        {
            long lo = 0, hi = maxX, best = -1;
            while (lo <= hi)
            {
                long mid = (lo + hi) >> 1;
                if (tree.Query(mid) >= h[i])
                {
                    best = mid;
                    hi = mid - 1;
                }
                else lo = mid + 1;
            }

            if (best == -1)
                Console.WriteLine(-1);
            else
                Console.WriteLine(Math.Abs(best - x[i]));
        }
    }
}